/*
 * File: HolePuncher.java
 * ================================================================
 * A program to simulate a hole puncher.
 */
import java.awt.event.*;

import acm.program.*;
import acm.graphics.*;

public class HolePuncher extends GraphicsProgram {
	/* Constant controlling the size of the circle to draw. */
	private static final double CIRCLE_RADIUS = 5;
	
	public void run() {
		/* Tell Java that we're ready for listeners. */
		addMouseListeners();
	}
	
	/**
	 * Punches a hole at the location where the user clicks.
	 * 
	 * @param e The event information.
	 */
	public void mouseClicked(MouseEvent e) {
		/* Position the circle where the mouse was clicked. */
		GOval hole = new GOval(e.getX() - CIRCLE_RADIUS,
				               e.getY() - CIRCLE_RADIUS,
				               2 * CIRCLE_RADIUS,
				               2 * CIRCLE_RADIUS);
		hole.setFilled(true);
		
		add(hole);
	}
}
